
#####################
# Intro rocket door #
#####################

# Open the door if a player is nearby
execute if entity @a[x=10,y=205,z=91,dx=1,dy=2,dz=2] if block 9 204 92 redstone_torch run setblock 9 204 92 air

# Close the door if there are no players nearby
execute unless entity @a[x=10,y=205,z=91,dx=1,dy=2,dz=2] unless block 9 204 92 redstone_torch run setblock 9 204 92 redstone_torch

###################
# Refilling boxes #
###################

# Place a new holoblock in the center box, but only if the box is empty
execute if blocks 8 77 8 8 77 8 8 76 8 all run data merge block 8 77 8 {Items:[{Slot:13b,id:"minecraft:glass",Count:1b,tag:{display:{Name:"{\"text\":\"§dInfinite Holoblock\"}",Lore:["{\"text\":\"§f4 Damage\"}","{\"text\":\"\"}","{\"text\":\"§7Right click to create holographic walls\"}","{\"text\":\"§7Left click to break holographic walls\"}","{\"text\":\"§7Can also be used as a basic weapon\"}"]},Enchantments:[{id:"minecraft:infinity",lvl:1}],AttributeModifiers:[{AttributeName:"generic.attack_damage",Name:"generic.attack_damage",Amount:4,Operation:0,UUID:[I;-1587294323,2076986907,-1439480646,450284343]}],CanDestroy:["minecraft:wall_torch","minecraft:glass","minecraft:torch"],CanPlaceOn:["spawner","quartz_block","acacia_bark","acacia_door","acacia_fence","acacia_leaves","acacia_log","acacia_planks","acacia_sapling","acacia_slab","acacia_stairs","activator_rail","allium","andesite","anvil","azure_bluet","banner","barrier","beacon","white_bed","orange_bed","magenta_bed","light_blue_bed","yellow_bed","lime_bed","pink_bed","gray_bed","light_gray_bed","cyan_bed","purple_bed","blue_bed","brown_bed","green_bed","red_bed","black_bed","bedrock","beetroots","birch_bark","birch_door","birch_fence","birch_fence_gate","birch_leaves","birch_log","birch_planks","birch_sapling","birch_slab","birch_stairs","black_carpet","black_concrete","black_concrete_powder","black_glazed_terracotta","black_shulker_box","black_stained_glass","black_stained_glass_pane","black_terracotta","black_wool","blue_carpet","blue_concrete","blue_concrete_powder","blue_glazed_terracotta","blue_orchid","blue_shulker_box","blue_stained_glass","blue_stained_glass_pane","blue_terracotta","blue_wool","bone_block","bookshelf","brewing_stand","brick_slab","brick_stairs","bricks","brown_carpet","brown_concrete","brown_concrete_powder","brown_glazed_terracotta","brown_mushroom","brown_mushroom_block","brown_shulker_box","brown_stained_glass","brown_stained_glass_pane","brown_terracotta","brown_wool","cactus","cake","carrots","cauldron","chain_command_block","chest","chipped_anvil","chiseled_quartz","chiseled_red_sandstone","chiseled_sandstone","chiseled_stone_bricks","chorus_flower","chorus_plant","clay","coal_block","coal_ore","coarse_dirt","cobblestone","cobblestone_slab","cobblestone_stairs","cobblestone_wall","cobweb","cocoa","command_block","comparator","cracked_stone_bricks","crafting_table","creeper_head","cut_red_sandstone","cut_sandstone","cyan_carpet","cyan_concrete","cyan_concrete_powder","cyan_glazed_terracotta","cyan_shulker_box","cyan_stained_glass","cyan_stained_glass_pane","cyan_terracotta","cyan_wool","damaged_anvil","dandelion","dark_oak_bark","dark_oak_door","dark_oak_fence","dark_oak_fence_gate","dark_oak_leaves","dark_oak_log","dark_oak_planks","dark_oak_sapling","dark_oak_slab","dark_oak_stairs","dark_prismarine","daylight_detector","dead_bush","detector_rail","diamond_block","diamond_ore","diorite","dirt","dispenser","dragon_egg","dragon_head","dropper","emerald_block","emerald_ore","enchanting_table","end_gateway","end_portal","end_portal_frame","end_rod","end_stone","end_stone_bricks","ender_chest","farmland","fern","fire","flower_pot","flowing_lava","flowing_water","frosted_ice","furnace","glass","glass_pane","glowstone","gold_block","gold_ore","granite","grass","grass_block","grass_path","gravel","gray_carpet","gray_concrete","gray_concrete_powder","gray_glazed_terracotta","gray_shulker_box","gray_stained_glass","gray_stained_glass_pane","gray_terracotta","gray_wool","green_carpet","green_concrete","green_concrete_powder","green_glazed_terracotta","green_shulker_box","green_stained_glass","green_stained_glass_pane","green_terracotta","green_wool","hay_bale","heavy_weighted_pressure_plate","hopper","ice","infested_chiseled_stone_bricks","infested_cobblestone","infested_cracked_stone_bricks","infested_mossy_stone_bricks","infested_stone","infested_stone_bricks","iron_bars","iron_block","iron_door","iron_ore","iron_trapdoor","jack_o_lantern","jukebox","jungle_bark","jungle_door","jungle_fence","jungle_fence_gate","jungle_leaves","jungle_log","jungle_planks","jungle_sapling","jungle_slab","jungle_stairs","ladder","lapis_block","lapis_ore","large_fern","lava","lever","light_blue_carpet","light_blue_concrete","light_blue_concrete_powder","light_blue_glazed_terracotta","light_blue_shulker_box","light_blue_stained_glass","light_blue_stained_glass_pane","light_blue_terracotta","light_blue_wool","light_gray_carpet","light_gray_concrete","light_gray_concrete_powder","light_gray_glazed_terracotta","light_gray_shulker_box","light_gray_stained_glass","light_gray_stained_glass_pane","light_gray_terracotta","light_gray_wool","light_weighted_pressure_plate","lilac","lily_pad","lime_carpet","lime_concrete","lime_concrete_powder","lime_glazed_terracotta","lime_shulker_box","lime_stained_glass","lime_stained_glass_pane","lime_terracotta","lime_wool","magenta_carpet","magenta_concrete","magenta_concrete_powder","magenta_glazed_terracotta","magenta_shulker_box","magenta_stained_glass","magenta_stained_glass_pane","magenta_terracotta","magenta_wool","magma_block","melon_block","melon_plant","melon_stem","mob_spawner","mossy_cobblestone","mossy_cobblestone_wall","mossy_stone_bricks","mycelium","nether_brick_fence","nether_brick_slab","nether_brick_stairs","nether_bricks","nether_portal","nether_quartz_ore","nether_wart","nether_wart_block","netherrack","note_block","oak_bark","oak_door","oak_fence","oak_fence_gate","oak_leaves","oak_log","oak_planks","oak_sapling","oak_slab","oak_stairs","observer","obsidian","orange_carpet","orange_concrete","orange_concrete_powder","orange_glazed_terracotta","orange_shulker_box","orange_stained_glass","orange_stained_glass_pane","orange_terracotta","orange_tulip","orange_wool","oxeye_daisy","packed_ice","peony","petrified_oak_slab","pink_carpet","pink_concrete","pink_concrete_powder","pink_glazed_terracotta","pink_shulker_box","pink_stained_glass","pink_stained_glass_pane","pink_terracotta","pink_tulip","pink_wool","piston","piston_head","player_head","podzol","polished_andesite","polished_diorite","polished_granite","poppy","potatoes","powered_rail","prismarine","prismarine_bricks","carved_pumpkin","pumpkin_stem","purple_carpet","purple_concrete","purple_concrete_powder","purple_glazed_terracotta","purple_shulker_box","purple_stained_glass","purple_stained_glass_pane","purple_terracotta","purple_wool","purpur_block","purpur_pillar","purpur_slab","purpur_stairs","smooth_quartz","quartz_pillar","quartz_slab","quartz_stairs","rail","red_carpet","red_concrete","red_concrete_powder","red_glazed_terracotta","red_mushroom","red_mushroom_block","red_nether_bricks","red_sand","red_sandstone","red_sandstone_slab","red_sandstone_stairs","red_shulker_box","red_stained_glass","red_stained_glass_pane","red_terracotta","red_tulip","red_wool","redstone_block","redstone_lamp","redstone_ore","redstone_torch","redstone_wire","repeater","repeating_command_block","rose_bush","sand","sandstone","sandstone_slab","sandstone_stairs","sea_lantern","sign","skeleton_skull","slime_block","smooth_red_sandstone","smooth_sandstone","smooth_stone","snow","snow_block","soul_sand","sponge","spruce_bark","spruce_door","spruce_fence","spruce_fence_gate","spruce_leaves","spruce_log","spruce_planks","spruce_sapling","spruce_slab","spruce_stairs","sticky_piston","stone","stone_brick_slab","stone_brick_stairs","stone_bricks","stone_button","stone_pressure_plate","stone_slab","structure_block","structure_void","sugar_cane","sunflower","tall_grass","terracotta","tnt","torch","trapped_chest","tripwire","tripwire_hook","vine","wall_sign","wall_torch","water","wet_sponge","wheat","white_carpet","white_concrete","white_concrete_powder","white_glazed_terracotta","white_shulker_box","white_stained_glass","white_stained_glass_pane","white_terracotta","white_tulip","white_wool","wither_skeleton_skull","oak_button","spruce_button","acacia_button","birch_button","dark_oak_button","jungle_button","oak_trapdoor","spruce_trapdoor","acacia_trapdoor","dark_oak_trapdoor","birch_trapdoor","jungle_trapdoor","yellow_carpet","yellow_concrete","yellow_concrete_powder","yellow_glazed_terracotta","yellow_shulker_box","yellow_stained_glass","yellow_stained_glass_pane","yellow_terracotta","yellow_wool","zombie_head","redstone_wall_torch","dark_oak_pressure_plate","acacia_pressure_plate","jungle_pressure_plate","spruce_pressure_plate","birch_pressure_plate","oak_pressure_plate","mushroom_stem","white_banner","orange_banner","magenta_banner","light_blue_banner","yellow_banner","lime_banner","pink_banner","gray_banner","light_gray_banner","cyan_banner","purple_banner","blue_banner","brown_banner","green_banner","red_banner","black_banner"],HideFlags:27}}]}

# Place a new headset in the bell tower box, but only if the box is empty
execute if blocks -84 113 52 -84 113 52 -84 110 52 all run data merge block -84 113 52 {Items:[{Slot:13b,id:"minecraft:golden_helmet",Count:1b,tag:{display:{Name:"{\"text\":\"\\\"The Pilgrimage\\\" VR Headset\",\"color\":\"gold\",\"italic\":\"false\"}"},HideFlags:7,Unbreakable:1b,Enchantments:[{id:"minecraft:unbreaking",lvl:1}]}}]}

# Place a new white wool in the tutorial box, but only if the box is empty
execute if blocks 107 208 32 107 208 32 107 205 32 all run data merge block 107 208 32 {Items:[{Slot:13b,id:"minecraft:white_wool",Count:1b,tag:{display:{Name:"{\"text\":\"Example Power Source\",\"color\":\"white\",\"italic\":\"false\"}"},Lore:["{\"text\":\"§cRemember: Press L to view your\"}","{\"text\":\"§cprogress towards each source!\"}"],HideFlags:7,Enchantments:[{id:"minecraft:unbreaking",lvl:1}]}}]}

########################
# Speedrun Mode Toggle #
########################

scoreboard players add @s SPEEDRUN 0

# Speedrun mode confirmation
execute if block 13 203 85 lever[powered=true] if entity @s[scores={SPEEDRUN=0,SPEEDRUN_LAST=0}] run tellraw @a [{"text":"Are you sure? Speedrun mode will skip dialogue and is not recommended for your first playthrough. ","color":"aqua"},{"text":"Open the chat and click here if you understand and wish to enable speedrun mode.","color":"aqua","underlined":"true","clickEvent":{"action":"run_command","value":"/trigger PURCHASE_ITEM set 15"}}]
execute if block 13 203 85 lever[powered=true] if entity @s[scores={SPEEDRUN=0}] run setblock 13 203 85 lever[facing=west]
execute if block 13 203 85 lever[powered=false] if entity @s[scores={SPEEDRUN=1}] run setblock 13 203 85 lever[facing=west,powered=true]
 
# Speedrun mode just turned off
execute if entity @s[scores={SPEEDRUN=0,SPEEDRUN_LAST=1}] at @a run playsound minecraft:block.beacon.deactivate master @a ~ ~ ~ 1 2
execute if entity @s[scores={SPEEDRUN=0,SPEEDRUN_LAST=1}] at @a run setblock 13 203 85 lever[facing=west]
execute if entity @s[scores={SPEEDRUN=0,SPEEDRUN_LAST=1}] run tellraw @a [{"text":"Speedrun mode disabled. ","color":"aqua"},{"text":"Open the chat and click here to enable speedrun mode.","color":"aqua","underlined":"true","clickEvent":{"action":"run_command","value":"/trigger PURCHASE_ITEM set 15"}}]

# Speedrun mode just turned on
execute if entity @s[scores={SPEEDRUN=1,SPEEDRUN_LAST=0}] at @a run playsound minecraft:block.beacon.activate master @a ~ ~ ~ 1 2
execute if entity @s[scores={SPEEDRUN=1,SPEEDRUN_LAST=0}] at @a run setblock 13 203 85 lever[facing=west,powered=true]
execute if entity @s[scores={SPEEDRUN=1,SPEEDRUN_LAST=0}] run tellraw @a [{"text":"Speedrun mode enabled. A timer will start as soon as you enter the rocket. ","color":"aqua"},{"text":"Or open the chat and click here to disable speedrun mode.","color":"aqua","underlined":"true","clickEvent":{"action":"run_command","value":"/trigger PURCHASE_ITEM set 16"}}]

# Update SPEEDRUN_LAST bool
execute if entity @s[scores={SPEEDRUN=0}] run scoreboard players set @s SPEEDRUN_LAST 0
execute if entity @s[scores={SPEEDRUN=1}] run scoreboard players set @s SPEEDRUN_LAST 1

#########################
# Intro/Ending Triggers #
#########################

# Map intro
execute if entity @s[scores={INTRO_TRIGGERED=0}] if entity @a[x=8,y=206,z=92,dx=0,dy=0,dz=0] run scoreboard players set @s TALK_NUM 13
execute if entity @s[scores={INTRO_TRIGGERED=0}] if entity @a[x=8,y=206,z=92,dx=0,dy=0,dz=0] run scoreboard players set @s TALK_TIME 1
execute if entity @s[scores={INTRO_TRIGGERED=0}] if entity @a[x=8,y=206,z=92,dx=0,dy=0,dz=0] run scoreboard players set @s INTRO_TRIGGERED 1

# Warp to beginning if intro already triggered
execute if entity @s[scores={INTRO_TRIGGERED=2}] if entity @a[x=8,y=206,z=92,dx=0,dy=0,dz=0] run tp @a[x=8,y=206,z=92,dx=0,dy=0,dz=0] 8 80 128 0 0

# Map ending
execute if entity @s[scores={TALK_TIME=20000..,ENDING_OPEN=1}] if entity @a[x=13,y=80,z=7,dx=0,dy=0,dz=0] run setblock 13 81 7 air
execute if entity @s[scores={TALK_TIME=20000..,ENDING_OPEN=1}] if entity @a[x=13,y=80,z=7,dx=0,dy=0,dz=0] run scoreboard players set @s TALK_NUM 12
execute if entity @s[scores={TALK_TIME=20000..,ENDING_OPEN=1}] if entity @a[x=13,y=80,z=7,dx=0,dy=0,dz=0] run scoreboard players set @s TALK_TIME 1

# Rocket particle effects
execute if entity @s[scores={INTRO_TRIGGERED=0}] run particle minecraft:flame 8 203 92 0 0 0 0.1 5 force
execute if entity @s[scores={ENDING_OPEN=1}] run particle minecraft:flame 13 77 7 0 0 0 0.1 5 force
execute if entity @s[scores={ENDING_OPEN=1}] run particle minecraft:smoke 13 79 7 0 0 0 0.1 1 force

######################
# Backstory Triggers #
######################

# Collecting the yellow supply
execute if entity @s[scores={YELLOW_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:yellow_wool"}]}] run scoreboard players set @s TALK_TIME 1
execute if entity @s[scores={YELLOW_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:yellow_wool"}]}] run scoreboard players add @s BACKSTORY_NUM 1
execute if entity @s[scores={YELLOW_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:yellow_wool"}]}] run scoreboard players operation @s TALK_NUM = @s BACKSTORY_NUM
execute if entity @s[scores={YELLOW_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:yellow_wool"}]}] run scoreboard players set @s WARPLOC 0
execute if entity @s[scores={YELLOW_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:yellow_wool"}]}] run scoreboard players set @s YELLOW_COLLECT 1

# Collecting the lime supply
execute if entity @s[scores={LIME_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:lime_wool"}]}] run scoreboard players set @s TALK_TIME 1
execute if entity @s[scores={LIME_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:lime_wool"}]}] run scoreboard players add @s BACKSTORY_NUM 1
execute if entity @s[scores={LIME_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:lime_wool"}]}] run scoreboard players operation @s TALK_NUM = @s BACKSTORY_NUM
execute if entity @s[scores={LIME_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:lime_wool"}]}] run scoreboard players set @s WARPLOC 3
execute if entity @s[scores={LIME_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:lime_wool"}]}] run scoreboard players set @s LIME_COLLECT 1

# Collecting the magenta supply
execute if entity @s[scores={MAGENTA_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:magenta_wool"}]}] run scoreboard players set @s TALK_TIME 1
execute if entity @s[scores={MAGENTA_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:magenta_wool"}]}] run scoreboard players add @s BACKSTORY_NUM 1
execute if entity @s[scores={MAGENTA_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:magenta_wool"}]}] run scoreboard players operation @s TALK_NUM = @s BACKSTORY_NUM
execute if entity @s[scores={MAGENTA_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:magenta_wool"}]}] run scoreboard players set @s WARPLOC 1
execute if entity @s[scores={MAGENTA_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:magenta_wool"}]}] run scoreboard players set @s MAGENTA_COLLECT 1

# Collecting the orange supply
execute if entity @s[scores={ORANGE_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:orange_wool"}]}] run scoreboard players set @s TALK_TIME 1
execute if entity @s[scores={ORANGE_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:orange_wool"}]}] run scoreboard players add @s BACKSTORY_NUM 1
execute if entity @s[scores={ORANGE_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:orange_wool"}]}] run scoreboard players operation @s TALK_NUM = @s BACKSTORY_NUM
execute if entity @s[scores={ORANGE_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:orange_wool"}]}] run scoreboard players set @s WARPLOC 2
execute if entity @s[scores={ORANGE_COLLECT=0}] if entity @a[nbt={Inventory:[{id:"minecraft:orange_wool"}]}] run scoreboard players set @s ORANGE_COLLECT 1

#############
# Sequences #
#############

function t:sequence/tutorial
function t:sequence/backstory_1
function t:sequence/backstory_2
function t:sequence/backstory_3

##################
# Sol Corp Doors #
##################

# If a player is nearby and has a light weighted pressure plate in their inventory, increment DOOR_OPEN_1
execute if entity @a[x=75,y=69,z=85,dx=5,dy=3,dz=10,nbt={Inventory:[{id:"minecraft:light_weighted_pressure_plate"}]}] run scoreboard players add @s DOOR_OPEN_1 1

# Slowly open the door as the scoreboard value increments
execute if entity @s[scores={DOOR_OPEN_1=5}] run clone 100 60 76 104 64 76 76 69 93
execute if entity @s[scores={DOOR_OPEN_1=10}] run clone 100 60 77 104 64 77 76 69 93
execute if entity @s[scores={DOOR_OPEN_1=15}] run clone 100 60 78 104 64 78 76 69 93
execute if entity @s[scores={DOOR_OPEN_1=20}] run clone 100 60 79 104 64 79 76 69 93
execute if entity @s[scores={DOOR_OPEN_1=25}] run clone 100 60 80 104 64 80 76 69 93
execute if entity @s[scores={DOOR_OPEN_1=5}] at @a run playsound minecraft:block.note_block.snare master @a ~ ~ ~ 1 0.5 0
execute if entity @s[scores={DOOR_OPEN_1=10}] at @a run playsound minecraft:block.note_block.snare master @a ~ ~ ~ 1 0.5 0
execute if entity @s[scores={DOOR_OPEN_1=15}] at @a run playsound minecraft:block.note_block.snare master @a ~ ~ ~ 1 0.5 0
execute if entity @s[scores={DOOR_OPEN_1=20}] at @a run playsound minecraft:block.note_block.snare master @a ~ ~ ~ 1 0.5 0
execute if entity @s[scores={DOOR_OPEN_1=25}] at @a run playsound minecraft:block.note_block.snare master @a ~ ~ ~ 1 0.5 0

# If a player is nearby, increment DOOR_OPEN_2
execute if entity @a[x=75,y=69,z=5,dx=6,dy=3,dz=6] run scoreboard players add @s DOOR_OPEN_2 1

# Slowly open the door as the scoreboard value increments
execute if entity @s[scores={DOOR_OPEN_2=5}] run clone 100 60 76 104 64 76 76 69 12
execute if entity @s[scores={DOOR_OPEN_2=10}] run clone 100 60 77 104 64 77 76 69 12
execute if entity @s[scores={DOOR_OPEN_2=15}] run clone 100 60 78 104 64 78 76 69 12
execute if entity @s[scores={DOOR_OPEN_2=20}] run clone 100 60 79 104 64 79 76 69 12
execute if entity @s[scores={DOOR_OPEN_2=25}] run clone 100 60 80 104 64 80 76 69 12
execute if entity @s[scores={DOOR_OPEN_2=5}] at @a run playsound minecraft:block.note_block.snare master @a ~ ~ ~ 1 0.5 0
execute if entity @s[scores={DOOR_OPEN_2=10}] at @a run playsound minecraft:block.note_block.snare master @a ~ ~ ~ 1 0.5 0
execute if entity @s[scores={DOOR_OPEN_2=15}] at @a run playsound minecraft:block.note_block.snare master @a ~ ~ ~ 1 0.5 0
execute if entity @s[scores={DOOR_OPEN_2=20}] at @a run playsound minecraft:block.note_block.snare master @a ~ ~ ~ 1 0.5 0
execute if entity @s[scores={DOOR_OPEN_2=25}] at @a run playsound minecraft:block.note_block.snare master @a ~ ~ ~ 1 0.5 0

################
# Force Fields #
################

# Turn force fields on & off
execute if block -50 84 52 lever[powered=true] run scoreboard players set @s FORCE_FIELD 1
execute if block -50 84 52 lever[powered=false] run scoreboard players set @s FORCE_FIELD 0

# Force field was just turned off
execute if entity @s[scores={FORCE_FIELD=0,FORCE_FIELD_LAST=1}] at @a run playsound minecraft:block.beacon.deactivate master @a ~ ~ ~ 1 2
execute if entity @s[scores={FORCE_FIELD=0,FORCE_FIELD_LAST=1}] run particle minecraft:end_rod -50 84 52 0 0 0 0.1 20 normal
execute if entity @s[scores={FORCE_FIELD=0,FORCE_FIELD_LAST=1}] run fill -78 98 52 -78 101 52 air
execute if entity @s[scores={FORCE_FIELD=0,FORCE_FIELD_LAST=1}] run fill -46 89 53 -46 91 51 air
execute if entity @s[scores={FORCE_FIELD=0,FORCE_FIELD_LAST=1}] run fill -47 69 53 -47 71 51 air

# Force field was just turned on
execute if entity @s[scores={FORCE_FIELD=1,FORCE_FIELD_LAST=0}] at @a run playsound minecraft:block.beacon.activate master @a ~ ~ ~ 1 2
execute if entity @s[scores={FORCE_FIELD=1,FORCE_FIELD_LAST=0}] run particle minecraft:end_rod -50 84 52 0 0 0 0.1 20 normal
execute if entity @s[scores={FORCE_FIELD=1,FORCE_FIELD_LAST=0}] run fill -47 69 53 -47 71 51 barrier
execute if entity @s[scores={FORCE_FIELD=1,FORCE_FIELD_LAST=0}] run fill -46 89 53 -46 91 51 barrier
execute if entity @s[scores={FORCE_FIELD=1,FORCE_FIELD_LAST=0}] run fill -78 98 52 -78 101 52 barrier

# Update FORCE_FIELD_LAST bool
execute if entity @s[scores={FORCE_FIELD=0}] run scoreboard players set @s FORCE_FIELD_LAST 0
execute if entity @s[scores={FORCE_FIELD=1}] run scoreboard players set @s FORCE_FIELD_LAST 1

# Force field particles
execute if block -50 84 52 lever[powered=true] run particle enchant -47 71 52 0 1 0.7 0 1 force
execute if block -50 84 52 lever[powered=true] run particle enchant -46 91 52 0 1 0.7 0 1 force
execute if block -50 84 52 lever[powered=true] run particle enchant -78 100 52 0 1 0.7 0 1 force

####################################
# Show/hide the helmet shulker box #
####################################

execute if block -240 57 52 yellow_shulker_box if entity @s[scores={MAGENTA_COLLECT=0}] run clone -240 57 52 -240 57 52 -240 55 52
execute if block -240 57 52 yellow_shulker_box if entity @s[scores={MAGENTA_COLLECT=0}] run setblock -240 57 52 snow_block
execute if block -240 57 52 snow_block if entity @s[scores={MAGENTA_COLLECT=1}] run clone -240 55 52 -240 55 52 -240 57 52

########
# Boss #
########

# Execute boss sequence
execute as @e[name="Boss",type=minecraft:drowned] at @s run function t:boss/loop

# Setup the ending when the boss is killed
execute if entity @s[scores={BOSS_ACTIVE=1}] unless entity @e[name="Boss",type=minecraft:drowned] run setblock 19 79 -11 air
execute if entity @s[scores={BOSS_ACTIVE=1}] unless entity @e[name="Boss",type=minecraft:drowned] run setblock 27 79 -3 air
execute if entity @s[scores={BOSS_ACTIVE=1}] unless entity @e[name="Boss",type=minecraft:drowned] run bossbar remove totality:boss
execute if entity @s[scores={BOSS_ACTIVE=1}] unless entity @e[name="Boss",type=minecraft:drowned] run scoreboard players set @s TALK_TIME 0
execute if entity @s[scores={BOSS_ACTIVE=1}] unless entity @e[name="Boss",type=minecraft:drowned] run scoreboard players set @s TALK_NUM 5
execute if entity @s[scores={BOSS_ACTIVE=1}] unless entity @e[name="Boss",type=minecraft:drowned] run tp @s 7 76.3 9
execute if entity @s[scores={BOSS_ACTIVE=1}] unless entity @e[name="Boss",type=minecraft:drowned] run playsound minecraft:entity.enderman.teleport hostile @a 7 76.3 9 1 1 1
execute if entity @s[scores={BOSS_ACTIVE=1}] unless entity @e[name="Boss",type=minecraft:drowned] run data merge entity @s {Pose:{LeftLeg:[0f,0f,0f],RightLeg:[0f,0f,0f],Head:[45f,0f,0f],LeftLeg:[283f,0f,0f],RightLeg:[283f,0f,0f]}}
execute if entity @s[scores={BOSS_ACTIVE=1}] unless entity @e[name="Boss",type=minecraft:drowned] run scoreboard players set @s BOSS_ACTIVE 0

################################
# Credits teleport & particles #
################################

execute if entity @s[scores={ENDING_OPEN=2}] run particle minecraft:totem_of_undying 7 207 -63 0 0 0 0.05 1 force
execute if entity @s[scores={ENDING_OPEN=2}] run particle minecraft:totem_of_undying 7 227 -63 10 20 10 0.01 5 force

execute if entity @s[scores={ENDING_OPEN=2}] run tp @a 7 197 -73

######################
# Dialogue Execution #
######################

# Check for sources being turned in
execute if entity @a[x=-5,y=77,z=-5,dx=25,dy=10,dz=25] run function t:monument/check

# Execute boss dialogue as Boss if the player is within a certain region
execute if entity @a[x=-5,y=77,z=-5,dx=25,dy=10,dz=25] run function t:dialogue/branch

# ...but for the backstory & ending dialogues, continue even if the player is far away
execute if entity @s[scores={TALK_NUM=4..,TALK_TIME=1..19999}] unless entity @a[x=-5,y=77,z=-5,dx=25,dy=10,dz=25] run function t:dialogue/branch

# Get grumpy & pause conversation if the player walks away
execute if entity @s[scores={BOSS_TALKING=1,TALK_NUM=..3,SPEEDRUN=0}] unless entity @a[x=-5,y=77,z=-5,dx=25,dy=10,dz=25] run tellraw @a {"text":"Where are you going? Information conveyance is not yet complete.","color":"yellow"}
execute if entity @s[scores={BOSS_TALKING=1,TALK_NUM=..3}] unless entity @a[x=-5,y=77,z=-5,dx=25,dy=10,dz=25] run scoreboard players set @s BOSS_TALKING 0

###################
# NPC Name Toggle #
###################

# Hide the name if the name is shown and there is no player in range
execute as @e[type=minecraft:armor_stand,tag=shown] at @s unless entity @a[distance=..10] run data merge entity @s {CustomNameVisible:0b}
execute as @e[type=minecraft:armor_stand,tag=shown] at @s unless entity @a[distance=..10] run tag @s remove shown

# Show the name if the name is not shown and there is a player in range
execute as @e[type=minecraft:armor_stand,tag=!shown] at @s unless entity @s[tag=hidename] if entity @a[distance=..10] run playsound minecraft:entity.enderman.ambient master @a ~ ~ ~ 0.5 1 0
execute as @e[type=minecraft:armor_stand,tag=!shown] at @s unless entity @s[tag=hidename] if entity @a[distance=..10] run data merge entity @s {CustomNameVisible:1b}
execute as @e[type=minecraft:armor_stand,tag=!shown] at @s unless entity @s[tag=hidename] if entity @a[distance=..10] run tag @s add shown

#########################
# NPC spawning/deletion #
#########################

# Spawn/delete npcs on the fly to reduce lag
function t:popin/loop

########
# Seer #
########

# Direct the player toward the tent
execute if entity @a[x=-14,y=73,z=-47,dx=18,dy=10,dz=6] if entity @s[scores={SEER_TALK=0}] run tellraw @a {"text":"<???> Psst! Hey you! Come this way, to the pointy tent ...","color":"aqua"}
execute if entity @a[x=-14,y=73,z=-47,dx=18,dy=10,dz=6] if entity @s[scores={SEER_TALK=0}] run scoreboard players set @s SEER_TALK 1

# Greet the player when they enter the tent, but only if the seer isn't already talking
execute if entity @a[x=-13,y=73,z=-45,dx=5,dy=3,dz=2] if entity @s[scores={SEER_TALK=1,HELP=0}] run tellraw @a [{"text":"<Seer> I foresaw your arrival. I am a seer of things lost and found. I can help you find that which you seek, for a price. ","color":"aqua"}]
execute if entity @a[x=-13,y=73,z=-45,dx=5,dy=3,dz=2] if entity @s[scores={SEER_TALK=1,HELP=0}] run tellraw @a [{"text":"Open the chat and click here to reveal your future ...","color":"aqua","underlined":"true","clickEvent":{"action":"run_command","value":"/trigger PURCHASE_ITEM set 13"}}]
execute if entity @a[x=-13,y=73,z=-45,dx=5,dy=3,dz=2] if entity @s[scores={SEER_TALK=1}] run scoreboard players set @s SEER_TALK 2

# Say goodbye when the player leaves, but only if the seer isn't already talking
execute unless entity @a[x=-13,y=73,z=-45,dx=5,dy=3,dz=2] if entity @s[scores={SEER_TALK=2,HELP=0}] run tellraw @a {"text":"<Seer> See you later ...","color":"aqua"}
execute unless entity @a[x=-13,y=73,z=-45,dx=5,dy=3,dz=2] if entity @s[scores={SEER_TALK=2}] run scoreboard players set @s SEER_TALK 1

# Display hint menu
execute if entity @s[scores={HELP=1}] run tellraw @a [{"text":"\n<Seer> What is it that you seek?\n\n","color":"aqua"},{"text":"A power source (3 credits)\n\n","color":"aqua","underlined":"true","clickEvent":{"action":"run_command","value":"/trigger PURCHASE_ITEM set 14"}},{"text":"A legendary item (2 credits)\n\n","color":"aqua","underlined":"true","clickEvent":{"action":"run_command","value":"/trigger PURCHASE_ITEM set 7"}},{"text":"A human artifact (1 credit)\n","color":"aqua","underlined":"true","clickEvent":{"action":"run_command","value":"/trigger PURCHASE_ITEM set 8"}}]
execute if entity @s[scores={HELP=1}] run scoreboard players set @s HELP 0

# Display power source hint submenu
execute if entity @s[scores={HELP=2}] run tellraw @a [{"text":"\n<Seer> Which source are you after?\n\n","color":"aqua"},{"text":"The yellow source (Sol Corp)\n\n","color":"aqua","underlined":"true","clickEvent":{"action":"run_command","value":"/trigger PURCHASE_ITEM set 9"}},{"text":"The magenta source (Lunatic Cathedral)\n\n","color":"aqua","underlined":"true","clickEvent":{"action":"run_command","value":"/trigger PURCHASE_ITEM set 10"}},{"text":"The orange source (Fungi Films)\n\n","color":"aqua","underlined":"true","clickEvent":{"action":"run_command","value":"/trigger PURCHASE_ITEM set 11"}},{"text":"The lime source (Ark Arboretum)\n\n","color":"aqua","underlined":"true","clickEvent":{"action":"run_command","value":"/trigger PURCHASE_ITEM set 12"}}]
execute if entity @s[scores={HELP=2}] run scoreboard players set @s HELP 0

# Display the rest of the seer dialogue
execute if entity @s[scores={HELP=3..}] run function t:dialogue/seer

##########
# Museum #
##########

# Check player's inventory for new museum items while they're standing in the museum
execute if entity @a[x=-67,y=66,z=79,dx=8,dy=2,dz=21] run function t:museum/check

# No destroying the blaze rod!
execute as @a[nbt={Inventory:[{id:"minecraft:blaze_powder"}]}] run tellraw @s {"text":"Don't destroy a perfectly good artifact!","color":"gold"}
execute as @a[nbt={Inventory:[{id:"minecraft:blaze_powder"}]}] run give @s blaze_rod{HideFlags:1,display:{Name:"{\"text\":\"§bHot Rod\"}",Lore:["§fAncient Human Artifact","","§7The humans used these for transportation","§7and motorsports."]},Enchantments:[{id:"minecraft:infinity",lvl:1}]} 1
execute as @a[nbt={Inventory:[{id:"minecraft:blaze_powder"}]}] run clear @s blaze_powder

#########
# Items #
#########

function t:item/bow
function t:item/bucket
function t:item/cyberpup
function t:item/flare
function t:item/headset
function t:item/holoblock
function t:item/pickaxe
function t:item/sources
function t:item/throwables
function t:item/trident

########
# Shop #
########

# Allow players to always trigger the PURCHASE_ITEM objective
scoreboard players enable @a PURCHASE_ITEM

# Purchasing items
execute as @a[scores={PURCHASE_ITEM=1..}] run function t:shop/purchase

########
# Mobs #
########

function t:entity/loop

###########
# Players #
###########

# Init new players
scoreboard players add @a PLAYER_SPAWNED 0
execute as @a[scores={PLAYER_SPAWNED=0}] run function t:player/init

# Give player saturation when their food bar goes down
effect give @a[scores={FOOD=..19}] saturation 1 0 true

# Player advancements
function t:player/advancements

# Player spawnpoints
function t:player/spawnpoints
